levels = {}

function NewLevelGlobalPop(id, population, unlockItems)
	local level = NewLevel(id)
	level.unlockItems = unlockItems
	level.objective = New("CCondition_Pop")
	level.objective.population = population
	return level
end

-- objective : build 10 extractors
levels.level1 = NewLevel(1)
levels.level1.unlockItems = { items.steel, items.extractor, items.depot }
levels.level1.objective = New("CCondition_ProduceMultiple")
levels.level1.objective.item = items.extractor
levels.level1.objective.count = 5
levels.level1.objective.itemFactory = items.factoryAssemblyPlant

-- objective : build 5 factories
levels.level2 = NewLevel(2)
levels.level2.unlockItems = { items.mechanicalParts, items.factory, items.factoryAssemblyPlant }
levels.level2.objective = New("CCondition_ProduceMultiple")
levels.level2.objective.item = items.factory
levels.level2.objective.count = 5
levels.level2.objective.itemFactory = items.factoryAssemblyPlant

levels.level3 = NewLevelGlobalPop(3, 20, { items.concrete, items.roadway, items.truck, items.cityIn })

levels.level4 = NewLevelGlobalPop(4, 50,
	{ items.aluminum, items.carbon, items.o2, items.factoryAtmExtractor, items.landmark })

levels.level5 = NewLevelGlobalPop(5, 100, { items.polymer, items.reinforcedConcrete, items.depotMK2 })

levels.level6 = NewLevel(6)
levels.level6.unlockItems = { items.sf6, items.factoryGHG }
levels.level6.objective = New("CCondition_Warmer")
levels.level6.objective.degrees = 1

levels.level7 = NewLevelGlobalPop(7, 300, { items.highTechParts })

levels.level8 = NewLevelGlobalPop(8, 500, { items.wasteMetal, items.cityOut, items.factoryRecycle })

levels.level9 = NewLevelGlobalPop(9, 1000, { items.railway, items.train })

levels.level10 = NewLevelGlobalPop(10, 2000, { items.wastePlastic, items.azote, items.nf3, items.iceExtractor })

levels.level11 = NewLevelGlobalPop(11, 3000, { items.dam, items.damPump })



-- Spacelift levels:

levels.level12 = NewLevel(12) -- auto place spacelift base ?
levels.level12.unlockItems = { items.carbonNanoTube, items.spaceliftCable, items.spacelift, items.constructionSite, items.nanoLab }
levels.level12.objective = New("CCondition_FinishSpaceLiftRecipe")
levels.level12.spaceLift_Placed = true

levels.level13 = NewLevelGlobalPop(13, 6000,
	{ items.diverseSeeds, items.food, items.water, items.compost, items.pumpingStation, items.factoryFood })

-- ADDED LEVEL
levels.level14 = NewLevelGlobalPop(14, 10000,
	{ items.forest_pine, items.forest_leavesHigh, items.factoryTree })


levels.level15 = NewLevelGlobalPop(15, 20000, { items.reinforcedSteel, items.composite })

levels.level16 = NewLevelGlobalPop(16, 30000, { items.diverseSeeds })
levels.level16.spaceLift_RecipeIndex = 1

levels.level17 = NewLevelGlobalPop(17, 50000, { items.diverseSeeds, items.wasteOrganic })
levels.level17.spaceLift_RecipeIndex = 2

levels.level18 = NewLevel(18)
levels.level18.unlockItems = {}
levels.level18.objective = New("CCondition_SpaceLiftRobbery")
levels.level18.objective.spacelift = items.spacelift
levels.level18.spaceLift_RecipeIndex = 3
levels.level18.spaceLift_AutodestroyWhenLevelComplete = true

levels.level19 = NewLevelGlobalPop(19, 75000, { items.diverseSeeds, items.depotMK3, items.botanicLab, items.containerShip })
-- levels.level19.objective = New("CCondition_EndOfBeta");

-- Defense levels:

levels.level20 = NewLevelGlobalPop(20, 100000, { items.dynamite, items.pileOfDirt, items.terrainTool }) -- items.terrainLevel, items.terrainSmooth,

levels.level21 = NewLevelGlobalPop(21, 200000, { items.farmSeeds, items.harvest, items.qualityFood, items.farm, items.silo, items.factoryAgricultural })

levels.level22 = NewLevelGlobalPop(22, 300000, { items.forest_cactus, items.forest_tropical, items.forest_coconut })

levels.level23 = NewLevelGlobalPop(23, 1000000, { items.supraConductor, items.robotics, items.energyLab, items.defenseShield }) -- display obj at 1m
levels.level23.temporaryObjective = New("CCondition_ShieldUp")

--levels.level23.objectiveFake = New("CCondition_Pop")
--levels.level23.objectiveFake.population = 1000000;

--levels.level24 = NewLevel(24);
--levels.level24.objective = New("CCondition_ShieldUp"); -- Surprise level with the first hit

--levels.level25 = NewLevelGlobalPop(25, 1000000, {});   -- "ok we are protected"

levels.level24 = NewLevel(24)
levels.level24.unlockItems = {}
levels.level24.objective = New("CCondition_EndGame");



GGame.levels = CreateLuaEntityList("CLevel", levels)
